part of 'select_brands_bloc.dart';

abstract class SelectBrandState extends Equatable {
  const SelectBrandState();
}

class SelectBrandInitial extends SelectBrandState {
  @override
  List<Object?> get props => [];
}

class LoadingState extends SelectBrandState {
  @override
  List<Object?> get props => [];
}

class BrandListSuccess extends SelectBrandState {
  final List<CarBrand> carBrandList;

  BrandListSuccess(this.carBrandList);
  @override
  List<Object?> get props => [carBrandList];
}

class FoundBrandFromList extends SelectBrandState {
  final List<CarBrand> carBrandList;

  FoundBrandFromList(this.carBrandList);
  @override
  List<Object?> get props => [carBrandList];
}

class ModelListSuccess extends SelectBrandState {
  final List<CarModel> carModelList;

  ModelListSuccess(this.carModelList);
  @override
  List<Object?> get props => [carModelList];
}

class FoundModelFromList extends SelectBrandState {
  final List<CarModel> carModelsList;

  FoundModelFromList(this.carModelsList);
  @override
  List<Object?> get props => [carModelsList];
}
