import 'package:flutter_bloc/flutter_bloc.dart';

import 'package:bloc/bloc.dart';
import 'package:equatable/equatable.dart';
import 'package:road24_mobile/data/repository/SelectBrandsRepository.dart';
import 'package:road24_mobile/data/response/CarsResponse.dart';

import 'package:road24_mobile/utils/extensions.dart';
part 'select_brands_event.dart';
part 'select_brands_state.dart';

class SelectBrandBloc extends Bloc<SelectBrandEvent, SelectBrandState> {
  final SelectBrandsRepository repository;

  static List<CarBrand> _carBrandList = [];
  static List<CarModel> _carModelList = [];

  SelectBrandBloc({required this.repository}) : super(SelectBrandInitial());

  @override
  Stream<SelectBrandState> mapEventToState(SelectBrandEvent event) async* {
    if (event is GetBrandsList) {
      try {
        yield LoadingState();

        final response = await repository.getBrands();

        if (response != null) {
          _carBrandList.clear();

          _carBrandList.addAll((response['results'] as List)
              .map((e) => CarBrand.fromJson(e))
              .toList());
        }

        yield BrandListSuccess(_carBrandList);

        add(SearchBrandsFromList(""));
      } catch (e) {
        print("brand list init try catch...$e");
      }
    } else if (event is SearchBrandsFromList) {
      var _text = event.text;

      yield LoadingState();

      if (_carBrandList.isNotEmpty) {
        if (_text.trim().isEmpty)
          yield FoundBrandFromList(_carBrandList);
        else {
          var _foundedList = _carBrandList.where(
            (e) {
              final it = e.name.toLowerCase();
              final s = _text.toLowerCase();
              return it.contains(s) || it.toLatin().contains(s.toLatin());
            },
          ).toList();

          yield FoundBrandFromList(_foundedList);
        }
      } else
        yield FoundBrandFromList([]);
    } else if (event is GetModelList) {
      try {
        final response = await repository.getModels(brandId: event.carBrandId);

        if (response != null) {
          _carModelList.clear();

          _carModelList.addAll((response['results'] as List)
              .map((e) => CarModel.fromJson(e))
              .toList());
        }

        yield ModelListSuccess(_carModelList);
        add(SearchModelsFromList(""));
      } catch (e) {
        print("model viewmodel..$e");
      }
    } else if (event is SearchModelsFromList) {
      var _text = event.text;

      yield LoadingState();

      if (_carModelList.isNotEmpty) {
        if (_text.trim().isEmpty)
          yield FoundModelFromList(_carModelList);
        else {
          var _foundedList = _carModelList.where(
            (e) {
              final it = e.name.toLowerCase();
              final s = _text.toLowerCase();
              return it.contains(s) || it.toLatin().contains(s.toLatin());
            },
          ).toList();

          yield FoundModelFromList(_foundedList);
        }
      } else
        yield FoundModelFromList([]);
    }
  }
}
