part of 'auth_bloc.dart';

abstract class AuthEvent extends Equatable {
  const AuthEvent();
}

class AddUserFullNameEvent extends AuthEvent {
  final String firstName;
  final String lastName;

  AddUserFullNameEvent({
    required this.lastName,
    required this.firstName,
  });

  @override
  List<Object> get props => [firstName, lastName];
}

class SMSSendingEvent extends AuthEvent {
  final String phone;

  SMSSendingEvent({
    required this.phone,
  });

  @override
  List<Object> get props => [phone];
}

class SMSVerificationEvent extends AuthEvent {
  final String phone;
  final String smsCode;

  SMSVerificationEvent(this.phone, this.smsCode);

  @override
  List<Object> get props => [phone, smsCode];
}
