import 'dart:io';

import 'package:device_info/device_info.dart';
import 'package:firebase_core/firebase_core.dart';
import 'package:flutter/foundation.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:road24_mobile/data/default_image.dart';
import 'package:road24_mobile/data/shared_data.dart';
import 'package:road24_mobile/my_app.dart';
import 'package:sentry_flutter/sentry_flutter.dart';

void main() async {
  WidgetsFlutterBinding.ensureInitialized();
  // await localhostServer.start();
  await certificate();
  await Firebase.initializeApp();
  await Preferences.createHiveBox();
  await DefaultImages.init();
  SystemChrome.setPreferredOrientations([DeviceOrientation.portraitUp]);
  await sentryInit(isRelease: kReleaseMode);
}

Future<void> sentryInit({required bool isRelease}) async {
  // if (isRelease) {
  //   final dsn =
  //       'https://07e27d52c9144d14a9a7d6bd6bff266f@o462986.ingest.sentry.io/5902112';
  //   await SentryFlutter.init(
  //     (options) {
  //       options.dsn = dsn;
  //        options.enableOutOfMemoryTracking = false;
  //     },
  //     appRunner: () => runApp(MyApp()),
  //   );
  // } else {

  runApp(MyApp());

  // }
}

certificate() async {
  if (Platform.isAndroid) {
    var androidInfo = await DeviceInfoPlugin().androidInfo;

    var sdkInt = androidInfo.version.sdkInt;

    if (sdkInt < 25) {
      ByteData data = await rootBundle.load('assets/raw/isrgrootx1.pem');

      SecurityContext context = SecurityContext.defaultContext;

      context.setTrustedCertificatesBytes(data.buffer.asUint8List());
    }
  }
}
