class InspectionManualVersionResponse {
  String? name;
  int? version;
  String? comment;

  InspectionManualVersionResponse({
    this.name,
    this.version,
    this.comment,
  });

  factory InspectionManualVersionResponse.fromJson(Map<String, dynamic> json) {
    return InspectionManualVersionResponse(
      name: json['name'] != null ? json["name"] : null,
      version: json['version'] != null ? json["version"] : null,
      comment: json['comment'] != null ? json["comment"] : null,
    );
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['name'] = this.name;
    data['version'] = this.version;
    data['comment'] = this.comment;
    return data;
  }

  @override
  String toString() {
    return "name...$name, version...$version, comment...$comment";
  }
}
