import 'package:road24_mobile/utils/frequent_widgets.dart';

class InspectionManualResponse {
  List address;

  InspectionManualResponse({required this.address});

  factory InspectionManualResponse.fromJson(Map<String, dynamic> json) {
    return InspectionManualResponse(
      address: json['data'] == null
          ? []
          : (json['data'] as List).map((e) => Address.fromJson(e)).toList(),
    );
  }
}

class Address {
  String name;
  String? additionalInfo;
  int regionId;
  int districtId;

  String? phone;
  String? phone1;
  String geolocatoin;
  String? workingDays;
  String? dinner;
  String? comment;
  String type;
  String? serviceProvince;
  String? address;
  bool legalEntityService;
  bool individualService;
  bool texpasportService;
  bool licenseService;

  Address({
    required this.name,
    this.additionalInfo,
    required this.regionId,
    required this.districtId,
    required this.legalEntityService,
    required this.individualService,
    required this.texpasportService,
    required this.licenseService,
    this.phone,
    this.phone1,
    required this.geolocatoin,
    this.workingDays,
    this.dinner,
    this.comment,
    required this.type,
    this.serviceProvince,
    this.address,
  });
  factory Address.fromJson(Map<String, dynamic> json) {
    return Address(
      name: json['name'],
      additionalInfo: json[FrequentWidgets.getTextConcat("additional_info")],
      individualService: json["individual_service"],
      legalEntityService: json["legal_entity_service"],
      texpasportService: json["texpasport_service"],
      regionId: json["region_id"],
      districtId: json["district_id"],
      licenseService: json["license_service"],
      phone: json['phone'],
      phone1: json['phone1'],
      geolocatoin: json['geolocation'],
      workingDays: json[FrequentWidgets.getTextConcat("working_days")],
      dinner: json['dinner_hours'],
      comment: json['comment'],
      type: json[FrequentWidgets.getTextConcat('type')],
      serviceProvince: json[FrequentWidgets.getTextConcat("service_province")],
      address: json[FrequentWidgets.getTextConcat("address")],
    );
  }
}
