class FinesManualVersionResponse {
  String name;
  int version;
  String comment;
  int basicCalculationAmount;

  FinesManualVersionResponse({
    required this.name,
    required this.version,
    required this.comment,
    required this.basicCalculationAmount,
  });

  factory FinesManualVersionResponse.fromJson(Map<String, dynamic> json) {
    return FinesManualVersionResponse(
      name: json['name'],
      version: json['version'],
      comment: json['comment'],
      basicCalculationAmount: json['basic_calculation_amount'],
    );
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['name'] = this.name;
    data['version'] = this.version;
    data['comment'] = this.comment;
    data['basic_calculation_amount'] = this.basicCalculationAmount;
    return data;
  }
}
