import 'package:road24_mobile/model/utils/Config.dart';
import 'package:road24_mobile/utils/frequent_widgets.dart';

// part 'FinesManualResponse.g.dart';

class FinesManualResponse {
  List<Articles> articles;
  List<Parts> parts;
  List<Categories> categories;

  FinesManualResponse(
      {required this.articles, required this.parts, required this.categories});

  factory FinesManualResponse.fromJson(Map<String, dynamic> json) {
    return FinesManualResponse(
      articles: json['articles'] == null
          ? []
          : (json['articles'] as List)
              .map((e) => Articles.fromJson(e))
              .toList(),
      parts: json['parts'] == null
          ? []
          : (json['parts'] as List).map((e) => Parts.fromJson(e)).toList(),
      categories: json['categories'] == null
          ? []
          : (json['categories'] as List)
              .map((e) => Categories.fromJson(e))
              .toList(),
    );
  }
}

class Articles {
  int id;
  String number;
  String title;
  String url;

  Articles({
    required this.id,
    required this.number,
    required this.title,
    required this.url,
  });

  factory Articles.fromJson(Map<String, dynamic> json) {
    late String url;
    if (Config.language == "ru") {
      url = 'url_ru';
    } else {
      url = "url_uz";
    }
    return Articles(
      id: json['id'],
      number: json['article_number'],
      title: json[FrequentWidgets.getTextConcat("article_name")],
      url: json[url],
    );
  }
  @override
  String toString() {
    return title;
  }
}

class Parts {
  int id;
  int articleId;
  int partNumber;
  String article;
  String description;
  String? fineForCitizen;
  String responsibleEntity;
  bool citizenDiscountApplicable;
  String categoryId;
  String? fineForOfficial;
  bool officialDiscountApplicable;
  String? fineComment;

  Parts({
    required this.article,
    required this.id,
    required this.articleId,
    required this.partNumber,
    required this.description,
    this.fineForCitizen,
    required this.responsibleEntity,
    required this.citizenDiscountApplicable,
    required this.categoryId,
    this.fineForOfficial,
    required this.officialDiscountApplicable,
    this.fineComment,
  });

  factory Parts.fromJson(Map<String, dynamic> json) {
    return Parts(
        article: json['article'],
        partNumber: json['part_number'],
        description: json[FrequentWidgets.getTextConcat('description')],
        fineForCitizen: json['fine_for_citizen'],
        responsibleEntity: json['responsible_entity'],
        citizenDiscountApplicable: json['citizen_discount_applicable'],
        categoryId: json['category_id'],
        fineForOfficial: json['fine_for_official'],
        officialDiscountApplicable: json['official_discount_applicable'],
        fineComment: json[FrequentWidgets.getTextConcat('fine_comment')],
        articleId: json['article_id'],
        id: json['id']);
  }
}

class Categories {
  int id;
  String articleCategories;
  String articleId;

  Categories({
    required this.id,
    required this.articleCategories,
    required this.articleId,
  });

  factory Categories.fromJson(Map<String, dynamic> json) {
    return Categories(
      id: json['id'],
      articleCategories: json[FrequentWidgets.getTextConcat("category_name")],
      articleId: json['article_id'],
    );
  }
}
