class FAQModel {
  int count;
  List<FAQResult> results;

  FAQModel({required this.count, required this.results});

  factory FAQModel.fromJson(Map<String, dynamic> json) {
    var list = json['results'] as List;
    List<FAQResult> results = list.map((i) => FAQResult.fromJson(i)).toList();

    return FAQModel(
      count: json['count'],
      results: results,
    );
  }
}

class FAQResult {
  int id;
  String? question;
  String? answer;

  FAQResult({required this.id, this.question, this.answer});

  factory FAQResult.fromJson(Map<String, dynamic> json) {
    return FAQResult(
      id: json['id'],
      question: json['question'],
      answer: json['answer'],
    );
  }
}
