class UserResponse {
  int id;
  String email;
  String phone;
  String gender;
  String firstName;
  String lastName;
  String birthday;
  int? location;

  UserResponse(
      {required this.id,
      this.location,
      required this.email,
      required this.phone,
      required this.firstName,
      required this.lastName,
      required this.birthday,
      required this.gender});

  factory UserResponse.fromJson(Map<String, dynamic> json) {
    return UserResponse(
        id: json['id'],
        email: json['email'],
        location: json['location'],
        phone: json['phone'],
        gender: json['gender'],
        firstName: json['first_name'],
        lastName: json['last_name'],
        birthday: json['birthday']);
  }
}
