class ReportsResponse {
  int? count;
  String? next;
  String? previous;
  List<Results>? results;

  ReportsResponse({this.count, this.next, this.previous, this.results});

  ReportsResponse.fromJson(Map<String, dynamic> json) {
    count = json['count'];
    next = json['next'];
    previous = json['previous'];
    if (json['results'] != null) {
      results = [];
      json['results'].forEach((v) {
        results!.add(new Results.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['count'] = this.count;
    data['next'] = this.next;
    data['previous'] = this.previous;
    if (this.results != null) {
      data['results'] = this.results!.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class Results {
  int? id;
  String? status;
  Address? address;
  Video? video;
  String? createdDate;

  Results({this.id, this.address, this.video, this.createdDate, this.status});

  Results.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    status = json['status'];
    address =
        json['address'] != null ? new Address.fromJson(json['address']) : null;
    video = json['video'] != null ? new Video.fromJson(json['video']) : null;
    createdDate = json['created_date'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    if (this.address != null) {
      data['address'] = this.address!.toJson();
    }
    if (this.video != null) {
      data['video'] = this.video!.toJson();
    }
    data['created_date'] = this.createdDate;
    return data;
  }
}

class Address {
  int? id;
  double? latitude;
  double? longitude;
  String? landmark;
  District? district;
  String? address;

  Address(
      {this.id,
      this.latitude,
      this.longitude,
      this.landmark,
      this.district,
      this.address});

  Address.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    latitude = json['latitude'];
    longitude = json['longitude'];
    landmark = json['landmark'];
    district = json['district'] != null
        ? new District.fromJson(json['district'])
        : null;
    address = json['address'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['latitude'] = this.latitude;
    data['longitude'] = this.longitude;
    data['landmark'] = this.landmark;
    if (this.district != null) {
      data['district'] = this.district!.toJson();
    }
    data['address'] = this.address;
    return data;
  }
}

class District {
  int? id;
  String? name;
  Region? region;

  District({this.id, this.name, this.region});

  District.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    name = json['name'];
    region =
        json['region'] != null ? new Region.fromJson(json['region']) : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['name'] = this.name;
    if (this.region != null) {
      data['region'] = this.region!.toJson();
    }
    return data;
  }
}

class Region {
  int? id;
  String? name;

  Region({this.id, this.name});

  Region.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    name = json['name'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['name'] = this.name;
    return data;
  }
}

class Video {
  int id;
  String name;
  String file;
  String videoPreview;
  String module;

  Video(
      {required this.id,
      required this.name,
      required this.file,
      required this.videoPreview,
      required this.module});

  factory Video.fromJson(Map<String, dynamic> json) {
    return Video(
        id: json['id'],
        name: json['name'],
        file: json['file'],
        videoPreview: json['video_preview'],
        module: json['module']);
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['name'] = this.name;
    data['file'] = this.file;
    data['video_preview'] = this.videoPreview;
    data['module'] = this.module;
    return data;
  }
}
