class ReportDetailResponse {
  int? id;
  Video? video;
  String? status;
  Video? extraVideo;
  String? extraVideoType;
  Address? address;
  String? incidentDatetime;
  List<Offences>? offences;
  Reward? reward;
  String? createdDate;

  ReportDetailResponse(
      {this.id,
      this.video,
      this.status,
      this.extraVideo,
      this.extraVideoType,
      this.address,
      this.incidentDatetime,
      this.offences,
      this.reward,
      this.createdDate});

  ReportDetailResponse.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    video = json['video'] != null ? new Video.fromJson(json['video']) : null;
    status = json['status'];
    extraVideo = json['extra_video'] != null
        ? new Video.fromJson(json['extra_video'])
        : null;
    extraVideoType = json['extra_video_type'];
    address =
        json['address'] != null ? new Address.fromJson(json['address']) : null;
    incidentDatetime = json['incident_datetime'];
    if (json['offences'] != null) {
      offences = [];
      json['offences'].forEach((v) {
        offences!.add(new Offences.fromJson(v));
      });
    }
    reward =
        json['reward'] != null ? new Reward.fromJson(json['reward']) : null;
    createdDate = json['created_date'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    if (this.video != null) {
      data['video'] = this.video!.toJson();
    }
    data['status'] = this.status;
    if (this.extraVideo != null) {
      data['extra_video'] = this.extraVideo!.toJson();
    }
    data['extra_video_type'] = this.extraVideoType;
    if (this.address != null) {
      data['address'] = this.address!.toJson();
    }
    data['incident_datetime'] = this.incidentDatetime;
    if (this.offences != null) {
      data['offences'] = this.offences!.map((v) => v.toJson()).toList();
    }
    if (this.reward != null) {
      data['reward'] = this.reward!.toJson();
    }
    data['created_date'] = this.createdDate;
    return data;
  }
}

class Video {
  int? id;
  String? name;
  String? file;
  String? videoPreview;
  String? module;

  Video({this.id, this.name, this.file, this.videoPreview, this.module});

  Video.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    name = json['name'];
    file = json['file'];
    videoPreview = json['video_preview'];
    module = json['module'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['name'] = this.name;
    data['file'] = this.file;
    data['video_preview'] = this.videoPreview;
    data['module'] = this.module;
    return data;
  }
}

class Address {
  int? id;
  double? latitude;
  double? longitude;
  String? landmark;
  District? district;
  String? address;

  Address(
      {this.id,
      this.latitude,
      this.longitude,
      this.landmark,
      this.district,
      this.address});

  Address.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    latitude = json['latitude'];
    longitude = json['longitude'];
    landmark = json['landmark'];
    district = json['district'] != null
        ? new District.fromJson(json['district'])
        : null;
    address = json['address'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['latitude'] = this.latitude;
    data['longitude'] = this.longitude;
    data['landmark'] = this.landmark;
    if (this.district != null) {
      data['district'] = this.district!.toJson();
    }
    data['address'] = this.address;
    return data;
  }
}

class District {
  int? id;
  String? name;
  Region? region;

  District({this.id, this.name, this.region});

  District.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    name = json['name'];
    region =
        json['region'] != null ? new Region.fromJson(json['region']) : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['name'] = this.name;
    if (this.region != null) {
      data['region'] = this.region!.toJson();
    }
    return data;
  }
}

class Region {
  int? id;
  String? name;

  Region({this.id, this.name});

  Region.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    name = json['name'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['name'] = this.name;
    return data;
  }
}

class Offences {
  int? id;
  String? vehicleId;
  String? testimony;

  Offences({this.id, this.vehicleId, this.testimony});

  Offences.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    vehicleId = json['vehicle_id'];
    testimony = json['testimony'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['vehicle_id'] = this.vehicleId;
    data['testimony'] = this.testimony;
    return data;
  }
}

class Reward {
  int? id;
  String? kind;
  String? enter;

  Reward({this.id, this.kind, this.enter});

  Reward.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    kind = json['kind'];
    enter = json['enter'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['kind'] = this.kind;
    data['enter'] = this.enter;
    return data;
  }
}
