class ProblemsResponse {
  int? count;
  dynamic next;
  dynamic previous;
  List<ProblemsResults>? results;

  ProblemsResponse({this.count, this.next, this.previous, this.results});

  ProblemsResponse.fromJson(Map<String, dynamic> json) {
    count = json['count'];
    next = json['next'];
    previous = json['previous'];
    if (json['results'] != null) {
      results = [];
      json['results'].forEach((v) {
        results!.add(new ProblemsResults.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['count'] = this.count;
    data['next'] = this.next;
    data['previous'] = this.previous;
    if (this.results != null) {
      data['results'] = this.results!.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class ProblemsResults {
  num? id;
  String? description;
  String? kind;
  Address? address;
  String? createdDate;
  num? votesCount;

  ProblemsResults(
      {this.id,
      this.description,
      this.kind,
      this.address,
      this.createdDate,
      this.votesCount});

  ProblemsResults.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    description = json['description'];
    kind = json['kind'];
    address =
        json['address'] != null ? new Address.fromJson(json['address']) : null;
    createdDate = json['created_date'];
    votesCount = json['votes_count'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['description'] = this.description;
    data['kind'] = this.kind;
    if (this.address != null) {
      data['address'] = this.address!.toJson();
    }
    data['created_date'] = this.createdDate;
    data['votes_count'] = this.votesCount;
    return data;
  }
}

class Address {
  District? district;
  String? address;

  Address({this.district, this.address});

  Address.fromJson(Map<String, dynamic> json) {
    district = json['district'] != null
        ? new District.fromJson(json['district'])
        : null;
    address = json['address'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    if (this.district != null) {
      data['district'] = this.district!.toJson();
    }
    data['address'] = this.address;
    return data;
  }
}

class District {
  num? id;
  String? name;
  Region? region;

  District({this.id, this.name, this.region});

  District.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    name = json['name'];
    region =
        json['region'] != null ? new Region.fromJson(json['region']) : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['name'] = this.name;
    if (this.region != null) {
      data['region'] = this.region!.toJson();
    }
    return data;
  }
}

class Region {
  num? id;
  String? name;

  Region({this.id, this.name});

  Region.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    name = json['name'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['name'] = this.name;
    return data;
  }
}
