class ProblemDetail {
  int? id;
  String? description;
  String? kind;
  List<Photos>? photos;
  Address? address;
  String? status;
  String? comment;
  String? createdDate;
  int? votesCount;
  bool? isVote;
  String? hashKey;

  ProblemDetail(
      {this.id,
      this.description,
      this.kind,
      this.photos,
      this.address,
      this.status,
      this.comment,
      this.createdDate,
      this.votesCount,
      this.isVote,
      this.hashKey});

  ProblemDetail.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    description = json['description'];
    kind = json['kind'];
    if (json['photos'] != null) {
      photos = [];
      json['photos'].forEach((v) {
        photos!.add(new Photos.fromJson(v));
      });
    }
    address =
        json['address'] != null ? new Address.fromJson(json['address']) : null;
    status = json['status'];
    comment = json['comment'];
    createdDate = json['created_date'];
    votesCount = json['votes_count'];
    isVote = json['is_vote'];
    hashKey = json['hash_key'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['description'] = this.description;
    data['kind'] = this.kind;
    if (this.photos != null) {
      data['photos'] = this.photos!.map((v) => v.toJson()).toList();
    }
    if (this.address != null) {
      data['address'] = this.address!.toJson();
    }
    data['status'] = this.status;
    data['comment'] = this.comment;
    data['created_date'] = this.createdDate;
    data['votes_count'] = this.votesCount;
    data['is_vote'] = this.isVote;
    data['hash_key'] = this.hashKey;
    return data;
  }
}

class Photos {
  int? id;
  String? name;
  String? file;
  Null videoPreview;
  String? module;

  Photos({this.id, this.name, this.file, this.videoPreview, this.module});

  Photos.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    name = json['name'];
    file = json['file'];
    videoPreview = json['video_preview'];
    module = json['module'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['name'] = this.name;
    data['file'] = this.file;
    data['video_preview'] = this.videoPreview;
    data['module'] = this.module;
    return data;
  }
}

class Address {
  int? id;
  double? latitude;
  double? longitude;
  String? landmark;
  District? district;
  String? address;

  Address(
      {this.id,
      this.latitude,
      this.longitude,
      this.landmark,
      this.district,
      this.address});

  Address.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    latitude = json['latitude'];
    longitude = json['longitude'];
    landmark = json['landmark'];
    district = json['district'] != null
        ? new District.fromJson(json['district'])
        : null;
    address = json['address'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['latitude'] = this.latitude;
    data['longitude'] = this.longitude;
    data['landmark'] = this.landmark;
    if (this.district != null) {
      data['district'] = this.district!.toJson();
    }
    data['address'] = this.address;
    return data;
  }
}

class District {
  int? id;
  String? name;
  Region? region;

  District({this.id, this.name, this.region});

  District.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    name = json['name'];
    region =
        json['region'] != null ? new Region.fromJson(json['region']) : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['name'] = this.name;
    if (this.region != null) {
      data['region'] = this.region!.toJson();
    }
    return data;
  }
}

class Region {
  int? id;
  String? name;

  Region({this.id, this.name});

  Region.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    name = json['name'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['name'] = this.name;
    return data;
  }
}

class VoteResponse {
  int? votesCount;

  VoteResponse({this.votesCount});

  VoteResponse.fromJson(Map<String, dynamic> json) {
    votesCount = json['votes_count'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['votes_count'] = this.votesCount;
    return data;
  }
}
