class NotificationResponse {
  int? count;
  String? next;
  String? previous;
  List<Results>? results;

  NotificationResponse({this.count, this.next, this.previous, this.results});

  NotificationResponse.fromJson(Map<String, dynamic> json) {
    count = json['count'];
    next = json['next'];
    previous = json['previous'];
    if (json['results'] != null) {
      results = [];
      json['results'].forEach((v) {
        results!.add(new Results.fromJson(v));
      });
    }
  }
}

class Results {
  int? id;
  NotificationContent? notificationContent;
  late bool isRead;
  String? createdDate;

  Results(
      {this.id,
      this.notificationContent,
      required this.isRead,
      this.createdDate});

  Results.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    notificationContent = json['notification_content'] != null
        ? new NotificationContent.fromJson(json['notification_content'])
        : null;
    isRead = json['is_read'];
    createdDate = json['created_date'];
  }
}

class NotificationContent {
  int? id;
  NotificationType? action;
  Content? content;

  NotificationContent({this.id, this.action, this.content});

  NotificationContent.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    action = typeParser[json['action']];
    content =
        json['content'] != null ? new Content.fromJson(json['content']) : null;
  }
}

class Content {
  late String body;
  Data? data;
  late String title;

  Content({required this.body, this.data, required this.title});

  Content.fromJson(Map<String, dynamic> json) {
    body = json['body'];
    data = json['data'] != null ? new Data.fromJson(json['data']) : null;
    title = json['title'];
  }
}

class Data {
  NotificationType? action;
  int? objId;
  String? clickAction;
  String? targetUrl;
  int? carDetailId;
  String? pDivision;
  String? dateNextInspection;
  String? androidUrl;
  String? iosUrl;

  Data({this.action, this.objId, this.clickAction});

  Data.fromJson(Map<String, dynamic> json) {
    action = typeParser[json['action']];
    objId = json['obj_id'];
    clickAction = json['click_action'];
    targetUrl = json['target_url'];
    carDetailId = json['carDetailId'];
    pDivision = json['pDivision'];
    dateNextInspection = json['dateNextInpsection'];
    androidUrl = json['android_url'];
    iosUrl = json['ios_url'];
  }
}

Map<String, NotificationType> typeParser = {
  "partial_paid_fine": NotificationType.PARTIAL_PAID_FINE,
  "completely_paid_fine": NotificationType.COMPLETELY_PAID_FINE,
  "new_fine": NotificationType.NEW_FINE,
  "pay_fine_success": NotificationType.PAY_FINE_SUCCESS,
  "pay_fine_failed": NotificationType.PAY_FINE_FAILED,
  "report_reviewed": NotificationType.REPORT_REVIEWED,
  "offence_changed_status": NotificationType.OFFENCE_CHANGED_STATUS,
  "fine_discount_ending": NotificationType.FINE_DISCOUNT_ENDING,
  "fine_images_found": NotificationType.FINE_IMAGES_FOUND,
  "inspection_coming_end": NotificationType.INSPECTION_COMING_END,
  "oil": NotificationType.OIL,
  "weather_status": NotificationType.WEATHER_STATUS,
  "road_block": NotificationType.ROAD_BLOCK,
  "trust": NotificationType.TRUST,
  "tinting": NotificationType.TINTING,
  "legal_news": NotificationType.LEGAL_NEWS,
  "big_news": NotificationType.BIG_NEWS,
  "add_car": NotificationType.ADD_CAR,
  "test_exercise": NotificationType.TEST_EXERCISE,
  "car_insurance": NotificationType.CAR_INSURANCE,
  "stores": NotificationType.STORES,
};

enum NotificationType {
  PARTIAL_PAID_FINE,
  COMPLETELY_PAID_FINE,
  NEW_FINE,
  PAY_FINE_SUCCESS,
  PAY_FINE_FAILED,
  REPORT_REVIEWED,
  OFFENCE_CHANGED_STATUS,
  FINE_DISCOUNT_ENDING,
  FINE_IMAGES_FOUND,
  INSPECTION_COMING_END,
  OIL,
  WEATHER_STATUS,
  ROAD_BLOCK,
  TRUST,
  TINTING,
  LEGAL_NEWS,
  BIG_NEWS,
  ADD_CAR,
  TEST_EXERCISE,
  CAR_INSURANCE,
  STORES,
}

class UnreadNotificationsCountResponse {
  int? totalCount;
  late int unreadCount;

  UnreadNotificationsCountResponse(
      {this.totalCount, required this.unreadCount});

  UnreadNotificationsCountResponse.fromJson(Map<String, dynamic> json) {
    totalCount = json['total_count'];
    unreadCount = json['unread_count'] ?? 0;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['total_count'] = this.totalCount;
    data['unread_count'] = this.unreadCount;
    return data;
  }
}
