class NewsResponse {
  int? count;
  dynamic next;
  dynamic previous;
  List<NewsResults>? results;

  NewsResponse({this.count, this.next, this.previous, this.results});

  NewsResponse.fromJson(Map<String, dynamic> json) {
    count = json['count'];
    next = json['next'];
    previous = json['previous'];
    if (json['results'] != null) {
      results = [];
      json['results'].forEach((v) {
        results!.add(new NewsResults.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['count'] = this.count;
    data['next'] = this.next;
    data['previous'] = this.previous;
    if (this.results != null) {
      data['results'] = this.results!.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class NewsResults {
  num? id;
  String? title;
  String? description;
  Photo? photo;
  String? jobType;
  bool? isPublished;
  String? createdDate;

  NewsResults(
      {this.id,
      this.title,
      this.description,
      this.photo,
      this.jobType,
      this.isPublished,
      this.createdDate});

  NewsResults.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    title = json['title'];
    description = json['description'];
    photo = json['photo'] != null ? new Photo.fromJson(json['photo']) : null;
    jobType = json['job_type'];
    isPublished = json['is_published'];
    createdDate = json['created_date'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['title'] = this.title;
    data['description'] = this.description;
    if (this.photo != null) {
      data['photo'] = this.photo!.toJson();
    }
    data['job_type'] = this.jobType;
    data['is_published'] = this.isPublished;
    data['created_date'] = this.createdDate;
    return data;
  }
}

class Photo {
  num? id;
  String? name;
  String? file;
  String? videoPreview;
  String? module;

  Photo({this.id, this.name, this.file, this.videoPreview, this.module});

  Photo.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    name = json['name'];
    file = json['file'];
    videoPreview = json['video_preview'];
    module = json['module'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['name'] = this.name;
    data['file'] = this.file;
    data['video_preview'] = this.videoPreview;
    data['module'] = this.module;
    return data;
  }
}
