class InspectionPlacesResponse {
  num? count;
  num? next;
  num? previous;
  List<InspectionPlacesResults>? results;

  InspectionPlacesResponse(
      {this.count, this.next, this.previous, this.results});

  InspectionPlacesResponse.fromJson(Map<String, dynamic> json) {
    count = json['count'];
    next = json['next'];
    previous = json['previous'];
    if (json['results'] != null) {
      results = [];
      json['results'].forEach((v) {
        results!.add(new InspectionPlacesResults.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['count'] = this.count;
    data['next'] = this.next;
    data['previous'] = this.previous;
    if (this.results != null) {
      data['results'] = this.results!.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class InspectionPlacesResults {
  int? id;
  String? name;

  InspectionPlacesResults({this.id, this.name});

  InspectionPlacesResults.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    name = json['name'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['name'] = this.name;
    return data;
  }
}
