class GetCardsResponse {
  int? count;
  dynamic next;
  dynamic previous;
  List<CardResults>? results;

  GetCardsResponse({this.count, this.next, this.previous, this.results});

  GetCardsResponse.fromJson(Map<String, dynamic> json) {
    count = json['count'];
    next = json['next'];
    previous = json['previous'];
    if (json['results'] != null) {
      results = [];
      json['results'].forEach((v) {
        results!.add(new CardResults.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['count'] = this.count;
    data['next'] = this.next;
    data['previous'] = this.previous;
    if (this.results != null) {
      data['results'] = this.results!.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class CardResults {
  late int id;
  String number;
  String fullName;
  String expire;
  bool isVerified;

  CardResults(
      {required this.id,
      required this.number,
      required this.fullName,
      required this.expire,
      required this.isVerified});

  factory CardResults.fromJson(Map<String, dynamic> json) {
    return CardResults(
        id: json['id'],
        number: json['number'],
        fullName: json['full_name'],
        expire: json['expire'],
        isVerified: json['is_verified']);
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['number'] = this.number;
    data['full_name'] = this.fullName;
    data['expire'] = this.expire;
    data['is_verified'] = this.isVerified;
    return data;
  }
}
