class GeoToAddressResponse {
  String? country;
  String? region;
  String? district;
  String? address;

  GeoToAddressResponse(
      {this.country, this.region, this.district, this.address});

  factory GeoToAddressResponse.fromJson(Map<String, dynamic> json) {
    return GeoToAddressResponse(
      country: json['country'],
      region: json['region'],
      district: json['district'],
      address: json['address'],
    );
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['country'] = this.country;
    data['region'] = this.region;
    data['district'] = this.district;
    data['address'] = this.address;
    return data;
  }
}
