class Fines {
  int? count;
  String? next;
  String? previous;
  List<Results>? results;

  Fines({this.count, this.next, this.previous, this.results});

  factory Fines.fromJson(Map<String, dynamic> json) {
    List<Results> results = [];

    if (json['results'] != null) {
      json['results'].forEach((v) {
        results.add(new Results.fromJson(v));
      });
    }
    return Fines(
        count: json['count'],
        next: json['next'],
        previous: json['previous'],
        results: results);
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['count'] = this.count;
    data['next'] = this.next;
    data['previous'] = this.previous;
    if (this.results != null) {
      data['results'] = this.results!.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class Results {
  int? id;
  String? pSeryNumber;
  String? pPlace;
  String? pLocation;
  PViolation? pViolation;
  String? pAmount;
  String? pDate;
  int? pStatus;
  String? remain;
  int? checkId;
  String? carNumber;
  int? parentId;

  Results(
      {this.id,
      this.pSeryNumber,
      this.pPlace,
      this.pLocation,
      this.pViolation,
      this.pAmount,
      this.pDate,
      this.pStatus,
      this.remain,
      this.checkId,
      this.parentId,
      this.carNumber});

  factory Results.fromJson(Map<String, dynamic> json) {
    return Results(
      id: json['id'],
      pSeryNumber: json['pSeryNumber'],
      pPlace: json['pPlace'],
      pLocation: json['pLocation'],
      pViolation: PViolation.fromJson(json['pViolation']),
      pAmount: json['pAmount'],
      pDate: json['pDate'],
      pStatus: json['pStatus'],
      remain: json['remain'],
      checkId: json['check_id'],
      parentId: json['parent_id'],
      carNumber:
          json['car_detail'] != null ? json['car_detail']['number'] : null,
    );
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['pSeryNumber'] = this.pSeryNumber;
    data['pPlace'] = this.pPlace;
    data['pLocation'] = this.pLocation;
    data['pViolation'] = this.pViolation;
    data['pDate'] = this.pDate;
    data['pStatus'] = this.pStatus;
    data['remain'] = this.remain;
    data["check_id"] = this.checkId;
    return data;
  }
}

class FineDetails {
  int? id;
  late String pSeryNumber;
  late String pPlace;
  late String pLocation;
  late String pDate;
  PViolation? pViolation;
  late String pAmount;
  late String remain;
  late int pStatus;
  late String pUrl;
  List<Pays>? pays;
  FineFile? pdf;
  FineFile? plateNumber;
  FineFile? plateNumberAndCar;
  DiscountAndPaid? discountAndPaid;
  Car? car;
  String? videoLink;
  String? extraVideoLink;
  double? latitude;
  double? longitude;

  FineDetails(
      {this.id,
      required this.pSeryNumber,
      required this.pPlace,
      required this.pLocation,
      required this.pDate,
      this.pViolation,
      required this.pAmount,
      required this.remain,
      required this.pStatus,
      required this.pUrl,
      this.pays,
      this.pdf,
      this.plateNumber,
      this.plateNumberAndCar,
      this.discountAndPaid,
      this.car,
      this.latitude,
      this.longitude,
      this.videoLink,
      this.extraVideoLink});

  FineDetails.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    pSeryNumber = json['pSeryNumber'];
    pPlace = json['pPlace'];
    pLocation = json['pLocation'];
    pDate = json['pDate'];
    pViolation = json['pViolation'] != null
        ? new PViolation.fromJson(json['pViolation'])
        : null;
    pAmount = json['pAmount'];
    remain = json['remain'];
    pStatus = json['pStatus'];
    pUrl = json['pUrl'];
    if (json['pays'] != null) {
      pays = [];
      json['pays'].forEach((v) {
        pays!.add(new Pays.fromJson(v));
      });
    }
    pdf = json['pdf'] != null ? new FineFile.fromJson(json['pdf']) : null;
    plateNumber = json['plate_number'] != null
        ? new FineFile.fromJson(json['plate_number'])
        : null;
    plateNumberAndCar = json['plate_number_and_car'] != null
        ? new FineFile.fromJson(json['plate_number_and_car'])
        : null;
    discountAndPaid = json['discount_and_paid'] != null
        ? new DiscountAndPaid.fromJson(json['discount_and_paid'])
        : null;
    car = json['car'] != null ? new Car.fromJson(json['car']) : null;
  }
}

class PViolation {
  late int id;
  late String desc;
  late String article;
  late int? part;

  PViolation(
      {required this.id,
      required this.desc,
      required this.article,
      required this.part});

  PViolation.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    desc = json['desc'];
    article = json['article'];
    part = json['part'];
  }
}

class Pays {
  int? id;
  String? pAmount;
  String? createdDate;

  Pays({this.id, this.pAmount, this.createdDate});

  Pays.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    pAmount = json['pAmount'];
    createdDate = json['created_date'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['pAmount'] = this.pAmount;
    data['created_date'] = this.createdDate;
    return data;
  }
}

class FineFile {
  int? id;
  String? name;
  String? file;
  String? videoPreview;
  String? module;

  FineFile(
      {this.id, this.name, required this.file, this.videoPreview, this.module});

  FineFile.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    name = json['name'];
    file = json['file'];
    videoPreview = json['video_preview'];
    module = json['module'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['name'] = this.name;
    data['file'] = this.file;
    data['video_preview'] = this.videoPreview;
    data['module'] = this.module;
    return data;
  }
}

class DiscountAndPaid {
  num? discount;
  num? paid;

  DiscountAndPaid({this.discount, this.paid});

  DiscountAndPaid.fromJson(Map<String, dynamic> json) {
    discount = json['discount'];
    paid = json['paid'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['discount'] = this.discount;
    data['paid'] = this.paid;
    return data;
  }
}

class Car {
  int id;

  Car({required this.id});

  factory Car.fromJson(Map<String, dynamic> json) {
    return Car(id: json['id']);
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    return data;
  }
}
