import 'FinesResponse.dart';

class ChequeListResponse {
  int? count;
  String? next;
  List<Results> results;

  ChequeListResponse({this.count, required this.results, this.next});

  factory ChequeListResponse.fromJson(Map<String, dynamic> json) {
    var resultList = json["results"] as List;
    List<Results> mapResults =
        resultList.map((e) => Results?.fromJson(e)).toList();
    return ChequeListResponse(
        count: json["count"], results: mapResults, next: json["next"]);
  }
}

class AllChequeListResponse {
  int? count;
  String? next;
  List<ChequeResult> results;

  AllChequeListResponse({this.count, required this.results, this.next});

  factory AllChequeListResponse.fromJson(Map<String, dynamic> json) {
    var resultList = json["results"] as List;
    List<ChequeResult> mapResults =
        resultList.map((e) => ChequeResult?.fromJson(e)).toList();
    return AllChequeListResponse(
        count: json["count"], results: mapResults, next: json["next"]);
  }
}
/*
"id": 117134,
            "pSeryNumber": "RA21408693461",
            "pPlace": "А373''М39 АЙ-БЎКА-АНГРЕН-ҚЎҚОН-АНДИЖОН-ЎШ'' АЙНИНГ 133КМ.ДАГИ ЧОРРАҲА.ОҲАНГАРОН ШАҲАР.",
            "pLocation": "",
            "pViolation": {
                "id": 36,
                "desc": "Превышение водителями транспортных средств установленной скорости движения на величину не более 20 километров в час",
                "article": "128X3",
                "part": 1
            },
            "pDate": "2021-05-17T16:20:57+05:00",
            "pStatus": 4,
            "plate_number_and_car": null,
            "remain": "0.00",
            "pAmount": "245000.00",
            "check_id": 5157
            */

class ChequeResult {
  int? id;
  String? createdDate;
  Results? fine;
  double? amount;
  double? commission;

  ChequeResult(
      {this.id, this.createdDate, this.fine, this.amount, this.commission});

  factory ChequeResult.fromJson(Map<String, dynamic> json) {
    return ChequeResult(
        id: json["id"],
        createdDate: json["created_date"],
        amount: double.tryParse(json["amount"])! / 100,
        commission: double.tryParse(json["commission"])! / 100,
        fine: Results.fromJson(json["fine"]));
  }
}
