class ChequeDetailsResponse {
  int id;
  String createdDate;
  CarModel? carModel;
  BankCardModel bankCardModel;
  FineModel fine;
  String amount;
  String commission;
  PayeeDetails payeeDetails;
  String purposeText;

  ChequeDetailsResponse(
      {required this.id,
      this.carModel,
      required this.createdDate,
      required this.bankCardModel,
      required this.fine,
      required this.amount,
      required this.commission,
      required this.payeeDetails,
      required this.purposeText});

  factory ChequeDetailsResponse.fromJson(Map<String, dynamic> json) {
    return ChequeDetailsResponse(
        id: json["id"],
        carModel: json["car"] != null ? CarModel.fromJson(json["car"]) : null,
        createdDate: json["created_date"],
        bankCardModel: BankCardModel.fromJson(json["bank_card"]),
        fine: FineModel.fromJson(json["fine"]),
        amount: (double.parse(json["amount"]) / 100).toString(),
        payeeDetails: PayeeDetails.fromJson(json["payee_details"]),
        purposeText: json["purpose_text"],
        commission: (double.parse(json["commission"]) / 100).toString());
  }
}

class BankCardModel {
  String? number;
  String? fullName;

  BankCardModel(this.number, this.fullName);

  factory BankCardModel.fromJson(Map<String, dynamic> json) {
    return BankCardModel(json["number"], json["full_name"]);
  }
}

class FineModel {
  String? pSeryNumber;
  String? remain;

  FineModel(this.pSeryNumber, this.remain);

  factory FineModel.fromJson(Map<String, dynamic> json) {
    return FineModel(json["pSeryNumber"], json["remain"]);
  }
}

class PayeeDetails {
  String? inn;
  String? name;
  String? branch;
  String? account;

  PayeeDetails(this.inn, this.name, this.branch, this.account);

  factory PayeeDetails.fromJson(Map<String, dynamic> json) {
    return PayeeDetails(
        json["inn"], json["name"], json["branch"], json["account"]);
  }
}

class CarModel {
  String? number;
  String? mark;
  String? name;

  CarModel(this.number, this.mark, this.name);

  factory CarModel.fromJson(Map<String, dynamic> json) {
    return CarModel(json["number"], json["mark"], json["name"]);
  }
}
