class CarsResponse {
  int count;
  List<Results> results;

  CarsResponse({
    required this.count,
    required this.results,
  });

  factory CarsResponse.fromJson(Map<String, dynamic> json) {
    return CarsResponse(
      count: json['count'],
      results: json['results'] == null
          ? []
          : (json['results'] as List).map((e) => Results.fromJson(e)).toList(),
    );
  }

  // Map<String, dynamic> toJson() {
  //   final Map<String, dynamic> data = new Map<String, dynamic>();
  //   data['count'] = this.count;
  //   data['next'] = this.next;
  //   data['previous'] = this.previous;
  //   data['results'] = this.results.map((v) => v.toJson()).toList();
  //   return data;
  // }

  CarsResponse copyWith({
    int? count,
    String? next,
    String? previous,
    List<Results>? results,
  }) {
    count = count ?? this.count;
    results = results ?? this.results;

    return CarsResponse(count: count, results: results);
  }
}

class Results {
  int id;
  String number;
  String techPassNum;
  String techPassSeries;
  String brand;
  String model;
  Image? image;
  CarModel? carModel;
  CarBrand? carBrand;
  Confidant? confidant;
  Inspection? inspection;
  Insurance? insurance;
  Tinting? tinting;
  Oil? oil;
  int finesCount;
  double finesRemain;
  int carDetail;
  String? dateOfRegistration;
  int? yearManufacture;
  bool pinned;

  Results({
    required this.id,
    required this.number,
    required this.techPassNum,
    required this.techPassSeries,
    required this.brand,
    required this.model,
    this.image,
    this.carModel,
    this.carBrand,
    this.confidant,
    this.inspection,
    this.insurance,
    this.tinting,
    this.oil,
    required this.finesCount,
    required this.finesRemain,
    required this.carDetail,
    this.dateOfRegistration,
    this.yearManufacture,
    required this.pinned,
  });

  factory Results.fromJson(Map<String, dynamic> json) {
    return Results(
      id: json['id'],
      number: json['number'],
      techPassNum: json['tech_pass_num'],
      techPassSeries: json['tech_pass_series'],
      brand: json['mark'],
      model: json['name'],
      image: json['image'] != null ? Image.fromJson(json['image']) : null,
      carModel: json['car_model'] != null
          ? CarModel.fromJson(json['car_model'])
          : null,
      carBrand: json['car_brand'] != null
          ? CarBrand.fromJson(json['car_brand'])
          : null,
      confidant: json['confidant'] != null
          ? Confidant.fromJson(json['confidant'])
          : null,
      inspection: json['inspection'] != null
          ? new Inspection.fromJson(json['inspection'])
          : null,
      insurance: json['insurance'] != null
          ? new Insurance.fromJson(json['insurance'])
          : null,
      tinting:
          json['tinting'] != null ? Tinting.fromJson(json['tinting']) : null,
      oil: json['oil'] != null ? Oil.fromJson(json['oil']) : null,
      finesCount: json['fines_count'],
      finesRemain: json['fines_remain'],
      carDetail: json['car_detail'],
      dateOfRegistration: json['date_of_registration'],
      yearManufacture: json['year_manufacture'],
      pinned: json['pinned'] ?? false,
    );
  }

  // Map<String, dynamic> toJson() {
  //   final Map<String, dynamic> data = new Map<String, dynamic>();
  //   data['id'] = this.id;
  //   data['number'] = this.number;
  //   data['tech_pass_num'] = this.techPassNum;
  //   data['tech_pass_series'] = this.techPassSeries;
  //   data['mark'] = this.brand;
  //   data['name'] = this.model;
  //   if (this.image != null) {
  //     data['confidant'] = this.image!.toJson();
  //   }
  //   if (this.carModel != null) {
  //     data['car_model'] = this.carModel!.toJson();
  //   }
  //   if (this.carBrand != null) {
  //     data['car_brand'] = this.carBrand!.toJson();
  //   }
  //   if (this.confidant != null) {
  //     data['confidant'] = this.confidant!.toJson();
  //   }
  //   if (this.inspection != null) {
  //     data['inspection'] = this.inspection!.toJson();
  //   }
  //   if (this.insurance != null) {
  //     data['insurance'] = this.insurance!.toJson();
  //   }
  //   if (this.tinting != null) {
  //     data['tinting'] = this.tinting!.toJson();
  //   }
  //   if (this.oil != null) {
  //     data['oil'] = this.oil!.toJson();
  //   }
  //   data['fines_count'] = this.finesCount;
  //   data['fines_remain'] = this.finesRemain;
  //   data['car_detail'] = this.carDetail;
  //   data['date_of_registration'] = this.dateOfRegistration;
  //   data['year_manufacture'] = this.yearManufacture;
  //   data['pinned'] = this.pinned;
  //   return data;
  // }

}

class Image {
  final int id;
  final String? name;
  final String? file;

  Image({required this.id, required this.name, this.file});

  factory Image.fromJson(Map<String, dynamic> json) {
    return Image(
        id: json["id"] ?? -1, name: json["name"] ?? "", file: json["file"]);
  }
  Map<String, dynamic> toJson() => {"id": id, "name": name, "file": file};
}

class CarModel {
  CarModel({
    required this.id,
    required this.carBrand,
    required this.name,
    this.image,
  });

  final int id;
  final int carBrand;
  final String name;
  final Image? image;

  factory CarModel.fromJson(Map<String, dynamic> json) {
    return CarModel(
      id: json["id"],
      carBrand: json["car_brand"],
      name: json["name"],
      image: json["image"] != null ? Image.fromJson(json["image"]) : null,
    );
  }
  Map<String, dynamic> toJson() =>
      {"id": id, "car_brand": carBrand, "name": name, "image": image?.toJson()};
}

class CarBrand {
  CarBrand({required this.id, required this.name, this.logo});

  final int id;
  final String name;
  final Image? logo;

  factory CarBrand.fromJson(Map<String, dynamic> json) {
    return CarBrand(
      id: json["id"] ?? -1,
      name: json["name"] ?? "",
      logo: json["logo"] != null ? Image.fromJson(json["logo"]) : null,
    );
  }

  // Map<String, dynamic> toJson() =>
  //     {"id": id, "name": name, "logo": logo?.toJson()};
}

class Confidant {
  int id;
  String kind;
  String series;
  String number;
  String datePassed;
  String dateEnd;
  String issuedTo;

  Confidant({
    required this.id,
    required this.kind,
    required this.series,
    required this.number,
    required this.datePassed,
    required this.dateEnd,
    required this.issuedTo,
  });

  factory Confidant.fromJson(Map<String, dynamic> json) {
    return Confidant(
      id: json['id'] ?? -1,
      kind: json['kind'] ?? '',
      series: json['series'] ?? '',
      number: json['number'] ?? '',
      datePassed: json['date_passed'] ?? '',
      dateEnd: json['date_end'] ?? '',
      issuedTo: json['issued_to'] ?? '',
    );
  }
}

class Inspection {
  int id;
  int car;
  String? datePassed;
  String? dateEnd;
  String pDivision;

  Inspection({
    required this.id,
    required this.car,
    this.datePassed,
    this.dateEnd,
    required this.pDivision,
  });

  factory Inspection.fromJson(Map<String, dynamic> json) {
    return Inspection(
      id: json['id'] ?? -1,
      car: json['car_detail'] ?? -1,
      datePassed: json['dateInpsection'],
      dateEnd: json['dateNextInpsection'],
      pDivision: json['pDivision'] ?? '',
    );
  }
}

class Insurance {
  int id;
  String kind;
  int numberOfDrivers;
  String companyName;
  String series;
  String number;
  String datePassed;
  String dateEnd;

  Insurance({
    required this.id,
    required this.kind,
    required this.numberOfDrivers,
    required this.companyName,
    required this.series,
    required this.number,
    required this.datePassed,
    required this.dateEnd,
  });

  factory Insurance.fromJson(Map<String, dynamic> json) {
    return Insurance(
      id: json['id'],
      kind: json['kind'],
      numberOfDrivers: json['number_of_drivers'],
      companyName: json['company_name'],
      series: json['series'],
      number: json['number'],
      datePassed: json['date_passed'],
      dateEnd: json['date_end'],
    );
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['kind'] = this.kind;
    data['number_of_drivers'] = this.numberOfDrivers;
    data['company_name'] = this.companyName;
    data['series'] = this.series;
    data['number'] = this.number;
    data['date_passed'] = this.datePassed;
    data['date_end'] = this.dateEnd;
    return data;
  }
}

class Tinting {
  int id;
  String kind;
  String series;
  String number;
  String datePassed;
  String dateEnd;

  Tinting({
    required this.id,
    required this.kind,
    required this.series,
    required this.number,
    required this.datePassed,
    required this.dateEnd,
  });

  factory Tinting.fromJson(Map<String, dynamic> json) {
    return Tinting(
      id: json['id'],
      kind: json['kind'],
      series: json['series'],
      number: json['number'],
      datePassed: json['date_passed'],
      dateEnd: json['date_end'],
    );
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    // data['car'] = this.car;
    data['kind'] = this.kind;
    data['series'] = this.series;
    data['number'] = this.number;
    data['date_passed'] = this.datePassed;
    data['date_end'] = this.dateEnd;
    return data;
  }
}

class Oil {
  int id;
  String mark;
  int mileage;
  int nextMileage;
  int chargePrice;
  int? oilMileage;
  int? dailyMileage;
  String lastReplacement;
  String nextReplacement;

  Oil(
      {required this.id,
      required this.mark,
      required this.mileage,
      required this.nextMileage,
      required this.chargePrice,
      required this.lastReplacement,
      required this.nextReplacement,
      this.oilMileage,
      this.dailyMileage});

  factory Oil.fromJson(Map<String, dynamic> json) {
    return Oil(
      id: json['id'],
      mark: json['mark'],
      mileage: json['mileage'],
      nextMileage: json['next_mileage'],
      chargePrice: json['charge_price'],
      lastReplacement: json['last_replacement'],
      nextReplacement: json['next_replacement'],
      dailyMileage: json['daily_mileage'],
      oilMileage: json['oil_mileage'],
    );
  }

  @override
  String toString() {
    return "daily $dailyMileage oil $oilMileage ";
  }
}

class CarDetailsResponse {
  int id;
  String number;
  String techPassNum;
  String techPassSeries;
  String mark;
  String name;
  Confidant? confidant;
  Inspection? inspection;
  Insurance? insurance;
  Tinting? tinting;
  Oil? oil;
  int finesCount;
  double finesRemain;

  CarDetailsResponse(
      {required this.id,
      required this.number,
      required this.techPassNum,
      required this.techPassSeries,
      required this.mark,
      required this.name,
      required this.confidant,
      required this.inspection,
      required this.insurance,
      required this.tinting,
      required this.oil,
      required this.finesCount,
      required this.finesRemain});

  factory CarDetailsResponse.fromJson(Map<String, dynamic> json) {
    return CarDetailsResponse(
      id: json['id'],
      number: json['number'],
      techPassNum: json['tech_pass_num'],
      techPassSeries: json['tech_pass_series'],
      mark: json['mark'],
      name: json['name'],
      confidant: json['confidant'] != null
          ? new Confidant.fromJson(json['confidant'])
          : null,
      inspection: json['inspection'] != null
          ? new Inspection.fromJson(json['inspection'])
          : null,
      insurance: json['insurance'] != null
          ? new Insurance.fromJson(json['insurance'])
          : null,
      tinting:
          json['tinting'] != null ? Tinting.fromJson(json['tinting']) : null,
      oil: json['oil'] != null ? new Oil.fromJson(json['oil']) : null,
      finesCount: json['fines_count'],
      finesRemain: json['fines_remain'],
    );
  }
}
