import 'package:road24_mobile/data/http/ApiRequest.dart';
import 'package:road24_mobile/data/http/ApiResponse.dart';

class YandexRepository {
  Future<dynamic> getGEOUsingLatLang(
      {required num lat, required num long}) async {
    dynamic response = await checkAddressApi(
        "https://api.road24.uz/api/mobile/v1/geo/geocoder/reverse?lat=$lat&lon=$long");
    // print('r'+response.toString());
    return response;
  }

  Future<dynamic> getGEOUsingAddress({required String address}) async {
    ApiResponse response = await checkAddressApi(
        "https://api.road24.uz/api/mobile/v1/geo/geocoder/search?q=$address");
    return response.data;
  }
}
