import 'package:road24_mobile/data/http/ApiRequest.dart';
import 'package:road24_mobile/data/http/ApiResponse.dart';

class UserRepository {
  Future<dynamic> registerWithPhone({required String phoneNumber}) async {
    print("auth phone     $phoneNumber");
    var response = await doPostRequest("users/auth/phone/",
        data: {"phone": phoneNumber}, version: "v2");
    print("data...." + response.toString());
    return response?.data;
  }

  Future<dynamic> verifySmsCode(
      {required String phoneNumber, required String smsCode}) async {
    ApiResponse? response = await doPostRequest(
      "users/auth/phone_verify/",
      data: {"phone": phoneNumber, "sms_code": smsCode},
    );

    return response?.data;
  }

  Future<dynamic> tokenRefresh({required String refresh}) async {
    ApiResponse? response = await doPostRequest("users/auth/token/refresh/",
        data: {"refresh": refresh});
    if (response != null) {
      return response.data;
    }
  }

  Future<dynamic> getUser() async {
    try {
      dynamic response = await doGetRequest("/users/me/");
      return response?.data;
    } catch (ex) {
      print("EXCEPTION on get user...." + ex.toString());
    }
  }

  Future<dynamic> updateUserFullData({
    String? firstName,
    String? lastName,
    String? email,
    int? imageId,
    String? gender,
    String? birthday,
    String? language,
  }) async {
    ApiResponse? response = await doPutRequest('users/me/', data: {
      "first_name": firstName,
      "last_name": lastName,
      "email": email,
      "gender": gender,
      "birthday": birthday,
      'language': language,
    });
    return response?.data;
  }

  Future<dynamic> changeLanguageTo(String language) async {
    ApiResponse? response = await doPutRequest('users/me/', data: {
      'language': language,
    });
    return response?.data;
  }
}
