import 'package:road24_mobile/data/http/ApiRequest.dart';

class SelectBrandsRepository {
  Future<dynamic> getBrands() async {
    final response = await doGetRequest(
      "cars/car_brands/?page_size=500",
      version: "v1",
    );
    return response?.data;
  }

  Future<dynamic> getModels({int? brandId}) async {
    String brand = "";
    if (brandId != null) brand = "&car_brand=$brandId";
    final response = await doGetRequest(
      "cars/car_models/?page_size=500$brand",
      version: "v1",
    );
    return response?.data;
  }
}
