import 'package:road24_mobile/data/http/ApiRequest.dart';
import 'package:road24_mobile/model/models/FileModel.dart';
import 'package:road24_mobile/model/models/ReportModel.dart';

class ReportsRepository {
  Future<dynamic> getReports({required int page, required int pageSize}) async {
    dynamic response =
        await doGetRequest("reports/?page=$page&page_size=$pageSize");
    print("RESPONSE");
    print(response);
    return response.data;
  }

  Future<dynamic> createReport(
      {required String type, required String number}) async {
    var data = {
      'video': FileModel.files[0].id,
      'incident_datetime': ReportModel.date,
      'reward': {'kind': type, 'enter': number},
      'address': {
        'latitude': ReportModel.lat,
        'longitude': ReportModel.lang,
      },
      'offences': ReportModel.list
          .map((e) => {
                'vehicle_id': e.value.carNumber.text.toString(),
                'testimony': e.value.reportDescription,
              })
          .toList()
    };
    if (FileModel.files.length > 1) {
      data.addAll({'extra_video': FileModel.files[1].id});
    }

    print(data);

    print('request is sent');
    final response = await doPostRequest("reports/", data: data);
    // print('request message '+ response.message);
    // print('request '+ response.response);
    // print('request data'+ response.data);
    return response?.data;
  }

  Future<dynamic> reportDetail(int id) async {
    dynamic response = await doGetRequest('reports/$id');
    return response;
  }
}
