import 'package:road24_mobile/data/http/ApiRequest.dart';

class ProblemRepository {
  Future<dynamic> getProblems({
    required int page,
    required int pageSize,
  }) async {
    final response = await doGetRequest(
      'problems/?page=$page&page_size=$pageSize',
    );
    return response?.data;
  }

  Future<dynamic> addProblem({
    String? description,
    String? kind,
    List<num>? photoIds,
  }) async {
    final response = await doPostRequest('problems/');
    return response?.data;
  }

  Future<dynamic> getProblem({required int id}) async {
    final response = await doGetRequest('problems/$id');
    return response?.data;
  }

  Future<dynamic> upVoteProblem({required int id}) async {
    final response = await doPostRequest('problems/$id/vote/');
    return response?.data;
  }
}
