import 'package:dio/dio.dart';
import 'package:road24_mobile/data/http/ApiRequest.dart';

class NotificationRepository {
  Future<dynamic> getNotifications(
      {required int page, required int pageSize}) async {
    final response = await doGetRequest(
      'notifications/?page=$page&page_size=$pageSize',
    ); //&ordering=is_read
    return response?.data;
  }

  Future<dynamic> getNotificationDetails(int id) async {
    // var dio = Dio();

    // var url = "https://radar24.free.beeceptor.com/notifications/1111/";
    // print("gettting");
    // var response = await dio.get(url);
    // print("ff");
    final response = await doGetRequest(
      'notifications/$id/',
    ); //&ordering=is_read
    print("data ${response?.data}");
    return response?.data;
    // return response.data;
  }

  Future<dynamic> userReadNotification(int id) async {
    dynamic response = await doPatchRequest(
      "notifications/$id/",
      data: {"is_read": true},
    );
    return response.data;
  }

  Future<dynamic> getUnreadNotificationsCount() async {
    dynamic response = await doGetRequest("notifications/count/");
    return response.data;
  }
}
