import 'package:road24_mobile/data/http/ApiRequest.dart';

class NewsRepository {
  Future<dynamic> getNews({num page = 1, num pageSize = 10}) async {
    dynamic response = await doGetRequest(
      'alerts/?page=$page&page_size=$pageSize',
    );
    return response.data;
  }

  Future<dynamic> readNews({required num id}) async {
    dynamic response = await doGetRequest(
      'alerts/$id',
    );
    return response.data;
  }
}
