import 'dart:io';

import 'package:dio/adapter.dart';
import 'package:dio/dio.dart';
import 'package:road24_mobile/data/response/manual_part/inspection/InspectionManualResponse.dart';
import 'package:road24_mobile/data/response/manual_part/inspection/RegionsModel.dart';
import 'package:road24_mobile/model/models/must_know_model.dart';

import '../../my_app.dart';

class ManualDirectusRepository {
  Dio dio = Dio();
  String baseUrl = "https://directus.yhxbb.uz/items";

  certificateEnable() {
    (dio.httpClientAdapter as DefaultHttpClientAdapter).onHttpClientCreate =
        (HttpClient client) {
      client.badCertificateCallback =
          (X509Certificate cert, String host, int port) => true;
      return client;
    };
  }

  Future<dynamic> getRegions() async {
    try {
      certificateEnable();

      final response = await dio.get(
        "$baseUrl/regions/",
      );

      var list = response.data["data"] as List;

      List<Regions> listOfReg = list.map((e) => Regions.fromJson(e)).toList();

      return listOfReg;
    } catch (ex) {
      print("in network error $ex");

      if (ex is DioError) {
        if (ex.toString().contains("SocketException") ||
            ex.toString().contains("timed out") ||
            ex.toString().contains("TimeOutException")) {
          print("internet is set to false");
          MyApp.hasInternet.value = false;

          throw Exception(ex.response!.statusCode.toString());
        }

        throw Exception(ex.toString() + ex.response!.statusCode.toString());
      }
    }
  }

  Future<dynamic> getDistricts() async {
    certificateEnable();

    try {
      final response = await dio.get("$baseUrl/districts?limit=300");

      var list = response.data["data"] as List;

      List<Districts> listOfDistricts =
          list.map((e) => Districts.fromJson(e)).toList();

      return listOfDistricts;
    } catch (ex) {
      print("district..$ex");
      if (ex is DioError) {
        if (ex.toString().contains("SocketException") ||
            ex.toString().contains("timed out") ||
            ex.toString().contains("TimeOutException")) {
          print("internet is set to false");
          MyApp.hasInternet.value = false;

          throw Exception(ex.response!.statusCode.toString());
        }

        throw Exception(ex.toString() + ex.response!.statusCode.toString());
      }
    }
  }

  Future<dynamic> getPlaces(int regionId) async {
    certificateEnable();

    try {
      final response =
          await dio.get("$baseUrl/texosmotr?filter[region_id]=$regionId");

      var list = response.data["data"] as List;
      print(list);
      List<Address> listOfPlaces = list.map((e) {
        print("index....${e["id"]}");
        return Address.fromJson(e);
      }).toList();

      return listOfPlaces;
    } catch (ex) {
      print("places..$ex");

      if (ex is DioError) {
        if (ex.toString().contains("SocketException") ||
            ex.toString().contains("timed out") ||
            ex.toString().contains("TimeOutException")) {
          print("internet is set to false");
          MyApp.hasInternet.value = false;

          throw Exception(ex.response!.statusCode.toString());
        }

        throw Exception(ex.toString() + ex.response!.statusCode.toString());
      }
    }
  }

  Future<dynamic> getMustKnowText() async {
    certificateEnable();
    try {
      final response = await dio.get("$baseUrl/my_car_page_know");

      var list = response.data["data"] as List;

      return MustKnowModel.fromJson(list[0]);
    } catch (ex) {
      print("must know..$ex");

      if (ex is DioError) {
        print("ex in must know $ex");
        if (ex.toString().contains("SocketException") ||
            ex.toString().contains("timed out") ||
            ex.toString().contains("TimeOutException")) {
          print("internet is set to false");
          MyApp.hasInternet.value = false;

          throw Exception(ex.response!.statusCode.toString());
        }

        throw Exception(ex.toString() + ex.response!.statusCode.toString());
      }
    }
  }
}
