import 'package:road24_mobile/data/http/ApiRequest.dart';

class InspectionsRepository {
  Future<dynamic> getPlaces() async {
    dynamic response = await doGetRequest(
        "cars/inspection-places/?page_size=30",
        queryParameters: {'ordering': 'id'});
    return response.data;
  }

  Future<dynamic> check({required int carDetailId}) async {
    dynamic response = await doPostRequest(
      "cars/inspections/check/",
      data: {"car_detail": carDetailId},
    );
    if (response != null) return response.data;
  }

  // Future<dynamic> getInspection({required int carDetail}) async {
  //   dynamic response = await doGetRequest(
  //     "cars/inspections/?car_detail=$carDetail",
  //   );
  //   return response.data;
  // }
}
