import 'package:road24_mobile/data/http/ApiRequest.dart';

class FinesRepository {
  Future<dynamic> getFines({
    required int carId,
    required int pageNumber,
    required int pageSize,
    required List<int> types,
  }) async {
    print('getFines');
    String typeToSend = '';
    for (int type in types) {
      typeToSend = typeToSend + type.toString() + ',';
    }
    typeToSend = typeToSend.substring(0, typeToSend.length - 1);
    var response = await doGetRequest(
      "cars/fine/",
      queryParameters: {
        'car': carId,
        'pStatus': typeToSend.toString(),
        'page_size': pageSize,
        'page': pageNumber,
        'ordering': '-pDate'
      },
    );
    print('data');
    return response?.data;
  }

  Future<dynamic> getFineById(int id) async {
    var response = await doGetRequest("cars/fine/$id/");
    return response?.data;
  }

  Future<void> refreshFineRemain(int id) async {
    var response = await doGetRequest("cars/fine/$id/refresh_remain");
    return response?.data;
  }
}
