import 'dart:io';

import 'package:dio/adapter.dart';
import 'package:dio/dio.dart';
import 'package:road24_mobile/data/response/manual_part/fines/FinesManualResponse.dart';
import 'package:road24_mobile/my_app.dart';

class FinesDirectusRepository {
  Dio dio = Dio(BaseOptions(
      connectTimeout: 60000, receiveTimeout: 60000, sendTimeout: 60000));

  String baseUrl = "https://directus.yhxbb.uz/items";

  certificateEnable() {
    (dio.httpClientAdapter as DefaultHttpClientAdapter).onHttpClientCreate =
        (HttpClient client) {
      client.badCertificateCallback =
          (X509Certificate cert, String host, int port) => true;
      return client;
    };
  }

  Future<dynamic> getCategories() async {
    try {
      certificateEnable();

      final response = await dio.get(
        "$baseUrl/traffic_fines_categories/?sort=id",
      );

      var list = response.data["data"] as List;

      List<Categories> listOfCategories =
          list.map((e) => Categories.fromJson(e)).toList();

      return listOfCategories;
    } catch (ex) {
      if (ex is DioError) {
        if (ex.toString().contains("SocketException") ||
            ex.toString().contains("timed out") ||
            ex.toString().contains("TimeOutException")) {
          MyApp.hasInternet.value = false;

          throw Exception(ex.response!.statusCode.toString());
        }
        print("articles..$ex");
        throw Exception(ex.toString() + ex.response!.statusCode.toString());
      }
    }
  }

  Future<dynamic> getArticles() async {
    certificateEnable();

    try {
      final response = await dio.get("$baseUrl/traffic_fines_articles?sort=id");

      var list = response.data["data"] as List;

      List<Articles> listOfArticles =
          list.map((e) => Articles.fromJson(e)).toList();
      return listOfArticles;
    } catch (ex) {
      if (ex is DioError) {
        if (ex.toString().contains("SocketException") ||
            ex.toString().contains("timed out") ||
            ex.toString().contains("TimeOutException")) {
          MyApp.hasInternet.value = false;

          throw Exception(ex.response!.statusCode.toString());
        }
        print("articles..$ex");
        throw Exception(ex.toString() + ex.response!.statusCode.toString());
      }
    }
  }

  Future<dynamic> getArticleParts({int? articleId, String? article}) async {
    certificateEnable();

    try {
      var url = "$baseUrl/traffic_fines_parts";

      var queryParameter = "";

      if (articleId != null) {
        queryParameter += "?filter[article_id]=$articleId";
      }
      if (article != null) {
        queryParameter += "?filter[article]=$article";
      }
      final response = await dio.get("$url$queryParameter");

      var list = response.data["data"] as List;
      print("parts from json");
      List<Parts> listOfArticleParts =
          list.map((e) => Parts.fromJson(e)).toList();
      print("after json");
      return listOfArticleParts;
    } catch (ex) {
      if (ex is DioError) {
        if (ex.toString().contains("SocketException") ||
            ex.toString().contains("timed out") ||
            ex.toString().contains("TimeOutException")) {
          MyApp.hasInternet.value = false;

          throw Exception(ex.response!.statusCode.toString());
        }
        print("article parts..$ex");
        throw Exception(ex.toString() + ex.response!.statusCode.toString());
      }
    }
  }
}
