import 'package:road24_mobile/data/http/ApiRequest.dart';

class ChequeRepository {
  Future<dynamic> getChequeList(
      {required int page, required int pageSize}) async {
    final response = await doGetRequest(
        "/cars/payments/?page=$page&page_size=$pageSize&ordering=-pDate");
    return response?.data;
  }

  Future<dynamic> getAllChequeList(
      {required int page, required int pageSize}) async {
    final response = await doGetRequest(
        "/transactions/checks/?page=$page&page_size=$pageSize");
    return response?.data;
  }

  Future<dynamic> getChequeDetailsById(int id) async {
    final response = await doGetRequest("/transactions/checks/$id/");
    return response?.data;
  }
}
