import 'dart:convert';

import 'package:dio/dio.dart';
import 'package:road24_mobile/data/http/ApiRequest.dart';
import 'package:road24_mobile/data/response/CarsResponse.dart';
import 'package:road24_mobile/model/models/AddCarModel.dart';

class CarsRepository {
  Future<dynamic> getCars() async {
    try {
      dynamic response = await doGetRequest(
        "cars/?page=1&&page_size=50",
        queryParameters: {"ordering": "-id"},
        version: 'v3',
      );

      return response.data;
    } catch (e) {
      print("Ex in cars: $e");
    }
  }

  Future<dynamic> getCarDetailsByID({required int id}) async {
    dynamic response = await doGetRequest("cars/$id/");
    return response.data;
  }

  Future<dynamic> getFines() async {
    dynamic response = await doGetRequest("cars/fine/");
    return response.data;
  }

  Future<dynamic> getFinesOfCar(int id) async {
    dynamic response = await doGetRequest("cars/fine/$id/");
    return response.data;
  }

  Future<dynamic> payFinesOfCar(int id, String bankCard, int amount) async {
    dynamic response = await doPostRequest("cars/fine/$id/pay/", data: {
      "bank_card": bankCard,
      "amount": amount,
    });
    return response.data;
  }

  Future<dynamic> addCar() async {
    if (AddCarModel.brandId == -1) AddCarModel.brandId = null;
    if (AddCarModel.modelId == -1) AddCarModel.modelId = null;
    if (AddCarModel.imageId == -1) AddCarModel.imageId = null;
    dynamic response = await doPostRequest(
      "cars/",
      data: {
        "number": AddCarModel.carNumber,
        "tech_pass_num": AddCarModel.tecNumber,
        "tech_pass_series": AddCarModel.tecSeries,
        "mark": AddCarModel.mark,
        "name": AddCarModel.name,
        "car_brand": AddCarModel.brandId,
        "car_model": AddCarModel.modelId,
        "image": AddCarModel.imageId,
      },
    );
    return response?.data;
  }

  Future<dynamic> editCar(int id, {bool? pinned}) async {
    if (AddCarModel.brandId == -1) AddCarModel.brandId = null;
    if (AddCarModel.modelId == -1) AddCarModel.modelId = null;
    if (AddCarModel.imageId == -1) AddCarModel.imageId = null;
    final data = {
      "number": AddCarModel.carNumber,
      "tech_pass_num": AddCarModel.tecNumber,
      "tech_pass_series": AddCarModel.tecSeries,
      "mark": AddCarModel.mark,
      "name": AddCarModel.name,
      "car_brand": AddCarModel.brandId,
      "car_model": AddCarModel.modelId,
      "image": AddCarModel.imageId,
    };
    if (pinned != null) data.addAll({"pinned": pinned});
    dynamic response = await doPatchRequest("cars/$id/", data: data);
    return response.data;
  }

  Future<dynamic> editCarConfidant(int id) async {
    dynamic response = await doPatchRequest(
      "cars/$id/",
      data: {
        "confidant": {
          "kind": AddConfidantModel.kind,
          "series": AddConfidantModel.confidantSeries,
          "number": AddConfidantModel.confidantNumber,
          "issued_to": AddConfidantModel.issuedTo,
          "date_passed": AddConfidantModel.datePassed,
          "date_end": AddConfidantModel.dateEnd,
        },
      },
    );
    return response.data;
  }

  Future<dynamic> editCarInspection(int id) async {
    dynamic response = await doPatchRequest(
      "cars/$id/",
      data: {
        "inspection": {
          "place": AddInspectionModel.place,
          "date_passed": AddInspectionModel.datePassed,
          "date_end": AddInspectionModel.dateEnd,
        },
      },
    );
    return response.data;
  }

  Future<dynamic> editCarInsurance(int id) async {
    dynamic response = await doPatchRequest(
      "cars/$id/",
      data: {
        "insurance": {
          "kind": AddInsuranceModel.kind,
          "number_of_drivers": AddInsuranceModel.numberOfDrivers,
          "company_name": AddInsuranceModel.companyName,
          "series": AddInsuranceModel.series,
          "number": AddInsuranceModel.number,
          "date_passed": AddInsuranceModel.datePassed,
          "date_end": AddInsuranceModel.dateEnd,
        },
      },
    );
    return response.data;
  }

  Future<dynamic> editCarTinting(int id) async {
    dynamic response = await doPatchRequest(
      "cars/$id/",
      data: {
        "tinting": {
          "kind": AddTintingModel.kind,
          "series": AddTintingModel.series,
          "number": AddTintingModel.number,
          "date_passed": AddTintingModel.datePassed,
          "date_end": AddTintingModel.dateEnd,
        },
      },
    );
    return response.data;
  }

  Future<List<Oil>> oilList(int carDetailId) async {
    var url = "https://radar24.free.beeceptor.com/oilList";

    var dio = Dio();

    print("stareted..");
    var response = await dio.get(url);
    print("ended..$response");
    var data = response.data["data"] as List;
    print("data is fetched $data");
    var oilLists = data.map((e) => Oil.fromJson(e)).toList();

    return oilLists;
  }

  Future<dynamic> editCarOil(int id, AddOilModel model) async {
    // var url = "https://radar24.free.beeceptor.com/oil";

    // var dio = Dio();

    // var data = {
    //   "mark": model.mark,
    //   "mileage": model.mileage,
    //   "next_mileage": model.nextMileage,
    //   "charge_price": model.chargePrice,
    //   "last_replacement": model.lastReplacement,
    //   "next_replacement": model.nextReplacement,
    //   "daily_mileage": model.dailyMileage,
    //   "oil_mileage": model.oilMileage
    // };

    // var response = await dio.post(url, data: jsonEncode(data));

    // return response.data;
    dynamic response = await doPatchRequest(
      "cars/$id/",
      data: {
        "oil": {
          "mark": model.mark,
          "mileage": model.mileage,
          "next_mileage": model.nextMileage,
          "charge_price": model.chargePrice,
          "last_replacement": model.lastReplacement,
          "next_replacement": model.nextReplacement,
          "daily_mileage": model.dailyMileage,
          "oil_mileage": model.oilMileage
        },
      },
    );
    return response.data;
  }

  Future<dynamic> deleteCar(int id) async {
    dynamic response = await doDeleteRequest(
      "cars/$id/",
    );
    return response.data;
  }

  Future<dynamic> checkCarExistence(
      String number, String tecNumber, String tecSeries) async {
    var url = "https://radar24.free.beeceptor.com/checkPlateNumber/";
    // var path = "checkPlateNumber/";

    var dio = Dio();

    var data = {
      "number": number,
      "tech_pass_num": tecNumber,
      "tech_pass_series": tecSeries,
    };

    var response = await dio.post(url, data: jsonEncode(data));
    // dynamic response = await doDeleteRequest(
    //   "cars/$id/",
    // );
    print("response...${response.data.toString()}");

    return response.data;
  }
}
