import 'package:road24_mobile/data/http/ApiRequest.dart';

class CardRepository {
  Future<dynamic> addCard({
    required String cardNumber,
    required String expire,
    required String name,
  }) async {
    final response = await doPostRequest("bank_cards/", data: {
      "number": cardNumber,
      "full_name": name,
      "expire": expire,
    });
    return response?.data;
  }

  Future<dynamic> getCards() async {
    final response = await doGetRequest("bank_cards/?page_size=100");
    return response?.data;
  }

  Future<dynamic> getCardById(int id) async {
    final response = await doGetRequest("bank_cards/$id/");
    return response?.data;
  }

  Future<dynamic> editCard(int id) async {
    final response = await doPutRequest("bank_cards/$id/");
    return response?.data;
  }

  Future<dynamic> deleteCard(int id) async {
    final response = await doDeleteRequest(
      "bank_cards/$id/",
    );
    return response?.data;
  }

  Future<dynamic> verify(int cardId, {required String code}) async {
    final response = await doPostRequest("bank_cards/$cardId/verify/", data: {
      "code": code,
    });
    return response?.data;
  }

  Future<dynamic> resendSmsCode(int cardId) async {
    final response =
        await doPostRequest("bank_cards/$cardId/resend_sms_code/", data: {});
    return response?.data;
  }

  Future<dynamic> pay(int fineId, int cardId, double amount,
      {String? smsCode}) async {
    Map<String, dynamic> bodyData = {"bank_card": cardId, "amount": amount};
    print("payment");
    if (smsCode != null) {
      bodyData["sms_code"] = smsCode;
    }

    final response = await doPostRequest(
      "cars/fine/$fineId/pay/",
      data: bodyData,
      version: 'v2',
      // version: 'v1',
    );
    return response;
  }
}
