import 'dart:convert';
import 'package:http/http.dart' as http;

class GeneralRequest {
  static Future<dynamic> getRequest(
    String url, {
    Map<String, String>? headers,
  }) async {
    try {
      final result = await http.get(
        Uri.parse(url),
        headers: headers,
      );
      return jsonDecode(result.body);
    } catch (e) {
      print(e);
      return null;
    }
  }

  static Future<dynamic> postRequest(
    String url, {
    dynamic body,
    Map<String, String>? headers,
  }) async {
    try {
      final httpHeaders = <String, String>{'Content-Type': 'application/json'};
      if (headers != null) httpHeaders.addAll(headers);

      final result = await http.post(
        Uri.parse(url),
        headers: httpHeaders,
        body: jsonEncode(body),
      );
      return jsonDecode(result.body);
    } catch (e) {
      print(e);
      return null;
    }
  }

  /// returns public IP address of a clinet
  static Future<String> getMyIp() async {
    var url = 'http://api.ipify.org/';

    try {
      final result = await http.get(Uri.parse(url));
      return result.body;
    } catch (e) {
      print(e);
      return 'unknown';
    }
  }
}
