class ApiResponse {
  final int error;
  final String message;
  final dynamic data;

  ApiResponse({required this.error, this.data, this.message = ''});

  factory ApiResponse.fromJson(dynamic json) {
    return ApiResponse(
      error: json != null ? 0 : -1,
      message:
          json != null ? 'Something  wrong on json body' : 'Json body is ok',
      data: json,
    );
  }

  isSuccess() {
    return error == 0;
  }

  isError() {
    return !isSuccess();
  }
}
