import 'dart:convert';
import 'package:dio/dio.dart';
import 'package:flutter/foundation.dart';

class ApiException implements Exception {
  static ValueNotifier<dynamic> errorMessage = ValueNotifier(null);
  static bool showServerErrors = false; //make false in production release
  final int? error;
  final String errMessage;
  final DioError? dioError;

  final bool apiError;
  final bool statusError;
  final int ?responseStatus;

  ApiException({
    this.error,
    this.errMessage='',
    this.dioError,
    this.apiError: false,
    this.statusError: false,
    this.responseStatus,
  });

  factory ApiException.fromJson(dynamic json) {
    if (json is String) json = jsonDecode(json);
    return ApiException(
      error: json['success'],
      errMessage: json['message'],
      apiError: true,
    );
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['error'] = this.error;
    data['errMessage'] = this.errMessage;
    data['apiError'] = this.apiError;
    data['statusError'] = this.statusError;
    data['responseStatus'] = this.responseStatus;
    return data;
  }

  @override
  String toString() => errMessage;

  String get message => errMessage;
}
