import 'dart:convert';

import 'package:flutter/services.dart';
import 'package:road24_mobile/data/response/CarsResponse.dart';

class DefaultImages {
  static List<CarBrand> _brands = [];
  static List<CarModel> _models = [];

  static Future<void> init() async {
    var text = await rootBundle.loadString('assets/brand/brands.json');
    var json = jsonDecode(text);
    _brands =
        (json['results'] as List).map((e) => CarBrand.fromJson(e)).toList();

    text = await rootBundle.loadString('assets/brand/models.json');
    json = jsonDecode(text);
    _models =
        (json['results'] as List).map((e) => CarModel.fromJson(e)).toList();
  }

  static Image? brandImage(String name) {
    final list = _brands
        .where((e) => e.name.toLowerCase() == name.toLowerCase())
        .toList();
    if (list.length != 0) return list[0].logo;
  }

  static Image? modelImage(String name) {
    final list = _models
        .where((e) => e.name.toLowerCase() == name.toLowerCase())
        .toList();
    if (list.length != 0) return list[0].image;
  }
}
