# Django
from django.contrib import admin
from django.conf import settings
from django.conf.urls.static import static
from django.http import HttpResponse
from django.urls import path, include

# Django Rest Framework
from rest_framework import permissions
from rest_framework.decorators import api_view
from rest_framework.routers import DefaultRouter

# Pypi: drf_yasg
from drf_yasg.views import get_schema_view
from drf_yasg import openapi

# Pypi: fcm_django
from fcm_django.api.rest_framework import FCMDeviceAuthorizedViewSet

from apps.notifications.views import NotificationEmulatorView

router = DefaultRouter()
router.register('api/devices', FCMDeviceAuthorizedViewSet)

patters = [
    path('api/notifications', NotificationEmulatorView.as_view()),
    path('api/admin/', include('config.urls.admin_urls', 'myadmin')),
    path('api/mobile/', include('config.urls.mobile_urls', 'mobile')),
    path('api/public/', include('config.urls.public_urls', 'public')),
    path('', include(router.urls))
]

schema_view = get_schema_view(
    openapi.Info(
        title="Snippets API",
        default_version='v1',
    ),
    public=True,
    permission_classes=[permissions.IsAdminUser],
    patterns=patters,
)


@api_view()
def loader_io(_):
    return HttpResponse('loaderio-30f5a135cff3cf53fd7eea2a25de056c')


urlpatterns = [
    path('loaderio-30f5a135cff3cf53fd7eea2a25de056c/', loader_io),
    path('docs/', schema_view.with_ui('swagger', cache_timeout=0),
         name='schema-swagger-ui'),
    path('redoc/', schema_view.with_ui('redoc', cache_timeout=0),
         name='schema-redoc'),
    path('admin/', admin.site.urls),
    path('webhook/', include('config.urls.webhook_urls', 'webhook')),
    *patters
]

if settings.DEBUG:
    urlpatterns += static(
        settings.STATIC_URL, document_root=settings.STATIC_ROOT
    )
    urlpatterns += static(
        settings.MEDIA_URL, document_root=settings.MEDIA_ROOT
    )
