from .settings import *
import dj_database_url

import sentry_sdk
from sentry_sdk.integrations.django import DjangoIntegration

sentry_sdk.init(
    dsn="https://2940741bee6f4123ab085af1812f504f@o462986.ingest.sentry.io/5981375",
    integrations=[DjangoIntegration()],
    sample_rate=1.0,
    traces_sample_rate=0.02,
    # If you wish to associate users to errors (assuming you are using
    # django.contrib.auth) you may enable sending PII data.
    send_default_pii=True
)

SECRET_KEY = os.environ['SECRET_KEY']

ENV = 'production'

DEBUG = False

ALLOWED_HOSTS = ['*']
CORS_ORIGIN_WHITELIST = ['localhost:3000', 'https://road24.netlify.app']

DATABASES = {
    'default': dj_database_url.parse(os.environ.get('DATABASE_URL')),
}
DATABASES['default']['ENGINE'] = 'django.contrib.gis.db.backends.postgis'

FIREBASE_AUTH = {
    "SERVICE_ACCOUNT_KEY_FILE": os.environ['FIREBASE_CONF_FILE_DIR']
}

FCM_DJANGO_SETTINGS = {
    "FCM_SERVER_KEY": os.environ['FCM_SERVER_KEY'],
    "ONE_DEVICE_PER_USER": False,
    "DELETE_INACTIVE_DEVICES": True,
}

SAFE_ROAD = {
    'SIGN_KEY': os.environ['SAFEROAD_SIGN_KEY'],
    'URL': os.environ['SAFEROAD_URL']
}

CACHES = {
    "default": {
        "BACKEND": "django_redis.cache.RedisCache",
        "LOCATION": os.environ['REDIS_URL'] + '/1',
        "OPTIONS": {
            "CLIENT_CLASS": "django_redis.client.DefaultClient",
        }
    }
}

CONN_MAX_AGE = 180  # minutes
