# Stdlib
from unittest.mock import patch, Mock

# Django Rest Framework
from rest_framework.test import APITestCase
from rest_framework import status

# Project
from apps.shared.tests import ViewSetTestCase, AuthTestCase
from apps.shared import messages
from ..models import Check


class CheckTest(APITestCase, ViewSetTestCase, AuthTestCase):
    fixtures = [
        'user.yaml',
        'cars.yaml',
        'car_model.yaml',
        'car_brand.yaml',
        'cards.yaml',
        'car_detail.yaml',
        'confidant.yaml',
        'inspection_places.yaml',
        'inspections.yaml',
        'insurance.yaml',
        'tinting.yaml',
        'oil.yaml',
        'violation.yaml',
        'violation_translation.yaml',
        'fines.yaml',
        'file.yaml',
        'check.yaml'
    ]

    url = 'mobile:checks-%s'

    def setUp(self):
        self._auth_admin()

    def test_unauth(self):
        self.client.credentials()

        response = self._list()
        self.assertEqual(response.status_code, status.HTTP_403_FORBIDDEN)

        response = self._retrieve({'pk': 1})
        self.assertEqual(response.status_code, status.HTTP_403_FORBIDDEN)

    def test_retrieve(self):
        response = self._retrieve({'pk': 1})
        self.assertEqual(response.status_code, status.HTTP_200_OK)
        self.assertEqual(response.data, {
            "id": 1,
            "created_date": "2017-01-01T00:00:00.100000+05:00",
            "car": {
                "number": "01A123AA",
                "mark": "Tesla1",
                "name": "Krutaya tachka1"
            },
            "bank_card": {
                "number": "8600123412341235",
                "full_name": "Elon Musk"
            },
            "fine": {
                "pSeryNumber": "RA20140040420",
                "remain": "1000.00"
            },
            "amount": '40000.00',
            "commission": None,
            "payee_details": None,
            "purpose_text": ""
        })

    def test_list(self):
        response = self._list()
        self.assertEqual(response.status_code, status.HTTP_200_OK)
        self.assertEqual(response.data['count'], 1)
        self.assertEqual(len(response.data['results']), 1)
        self.assertEqual(
            response.data['results'][0], {
                "id": 1,
                "created_date": "2017-01-01T00:00:00.100000+05:00",
                "fine": {
                    "id": 3,
                    "pPlace": 'ЮҚОРИЧИРЧИҚ ТУМАНИ 4Р-',
                    "pViolation": {
                        "id": 1,
                        "desc": "Езда без ременя безопасности",
                        "article": "125",
                        "part": 1
                    },
                    "pSeryNumber": "RA20140040420",
                    "remain": '1000.00'
                },
                "amount": '40000.00',
                "commission": None
            })

    def test_list_filter_car_detail(self):
        response = self._list({'fine__car_detail': 1})
        self.assertEqual(response.status_code, status.HTTP_200_OK)
        self.assertEqual(response.data['count'], 1)
        self.assertEqual(len(response.data['results']), 1)

    def test_pagination(self):
        response = self._list({'page_size': 1})
        self.assertEqual(response.status_code, status.HTTP_200_OK)
        self.assertEqual(response.data['count'], 1)
        self.assertEqual(len(response.data['results']), 1)
