# Django
from django.db import models

# Project
from apps.shared.models import BaseModel
from apps.cars.models import Car


class Check(BaseModel):
    bank_card = models.ForeignKey(
        'bank_cards.BankCard',
        on_delete=models.PROTECT,
        related_name='checks'
    )
    user = models.ForeignKey(
        'gauth.User',
        on_delete=models.PROTECT,
        related_name='checks'
    )
    fine = models.ForeignKey(
        'cars.Fine',
        on_delete=models.PROTECT,
        related_name='checks',
        null=True
    )
    state = models.SmallIntegerField()
    amount = models.DecimalField(max_digits=11, decimal_places=2, null=True)
    commission = models.DecimalField(max_digits=11, decimal_places=2,
                                     null=True)
    purpose_text = models.TextField(blank=True)
    payee_details = models.JSONField(null=True)
    result = models.JSONField()

    @property
    def car(self):
        return Car.objects.filter(
            user=self.user, car_detail_id=self.fine.car_detail).first()
