# Django
from django.db.models import F, Q, Max

# Django Rest Framework
from rest_framework import mixins
from rest_framework.viewsets import ReadOnlyModelViewSet
from rest_framework.permissions import IsAuthenticated

# Project
from .serializers import CheckSerializer, CheckListSerializer
from ..models import Check


class CheckViewSet(ReadOnlyModelViewSet):
    permission_classes = (IsAuthenticated,)
    filterset_fields = ['fine__car_detail']

    def get_queryset(self):
        queryset = Check.objects.filter(
            fine__car_detail__cars__user=self.request.user,
            fine__car_detail__cars__is_deleted=False,
        ).distinct()
        if self.action == 'list':
            return queryset.select_related('fine__pViolation')
        return queryset.select_related(
            'fine__car_detail',
            'bank_card',
            'fine'
        )

    def get_serializer_class(self):
        if self.action == 'list':
            return CheckListSerializer
        return CheckSerializer
