# Django Rest Framework
from rest_framework import serializers

# Project
from ..models import Check
from apps.cars.mobile.serializers.car import CarSerializer
from apps.cars.mobile.serializers.fine import FineSerializer
from apps.bank_cards.mobile.serializers import BankCardSerializer


class CheckSerializer(serializers.ModelSerializer):
    bank_card = BankCardSerializer(fields=('number', 'full_name'))
    fine = FineSerializer(fields=('pSeryNumber', 'remain'))
    car = CarSerializer(fields=('name', 'mark', 'number'))

    class Meta:
        model = Check
        fields = (
            'id',
            'created_date',
            'car',
            'bank_card',
            'fine',
            'amount',
            'commission',
            'payee_details',
            'purpose_text'
        )


class CheckListSerializer(serializers.ModelSerializer):
    fine = FineSerializer(
        fields=('id', 'pViolation', 'pPlace', 'pSeryNumber', 'remain'))

    class Meta:
        model = Check
        fields = (
            'id',
            'created_date',
            'fine',
            'amount',
            'commission',
        )
