# Django Rest Framework
from rest_framework.viewsets import ReadOnlyModelViewSet
from rest_framework.permissions import IsAuthenticated

# Project
from .serializers import (
    IOSVersionSerializer,
    AndroidVersionSerializer,
    FirebaseVersionSerializer
)
from .models import IOSVersion, AndroidVersion, FirebaseVersion


class AndroidVersionViewSet(ReadOnlyModelViewSet):
    permission_classes = ()
    queryset = AndroidVersion.objects.all()
    serializer_class = AndroidVersionSerializer


class IOSVersionViewSet(ReadOnlyModelViewSet):
    permission_classes = ()
    queryset = IOSVersion.objects.all()
    serializer_class = IOSVersionSerializer


class FirebaseVersionViewSet(ReadOnlyModelViewSet):
    permission_classes = ()
    queryset = FirebaseVersion.objects.all()
    serializer_class = FirebaseVersionSerializer
