# Django
from django.urls import path, include

# Django Rest Framework
from rest_framework.routers import DefaultRouter

# Project
from .views import (
    IOSVersionViewSet,
    AndroidVersionViewSet,
    FirebaseVersionViewSet
)

router = DefaultRouter()
router.register('android_version', AndroidVersionViewSet, 'ios_version')
router.register('ios_version', IOSVersionViewSet, 'android_version')
router.register('firebase_version', FirebaseVersionViewSet, 'firebase_version')

urlpatterns = [
    path('', include(router.urls))
]
