# Django
from django.db import models


class Setting(models.Model):
    GET_SMS = 0
    PLAY_MOBILE = 1

    SMS_GATEWAY_CHOICES = (
        (GET_SMS, 'Getsms'),
        (PLAY_MOBILE, 'Play mobile')
    )

    sms_gateway = models.SmallIntegerField(choices=SMS_GATEWAY_CHOICES)


class AndroidVersion(models.Model):
    version = models.CharField(max_length=20)


class IOSVersion(models.Model):
    version = models.CharField(max_length=20)


class FirebaseVersion(models.Model):
    version = models.CharField(max_length=20)
